;Finer tempo control than the default player \o/
TEMPO       equ 140     ;beats per minute

;FPS = 50 for PAL, 60 for NTSC
TEMPODELTA  equ 256 * 32 * TEMPO / (FPS * 240)

INTRO   equ 1

;low bass notes
F3      equ %10111101
G3      equ %10111010
As3     equ %10110101   ;red, +37
C4      equ %10110011

;high bass notes
G3      equ %10111010
A3      equ %10110111
C4      equ %10110011
D4      equ %10110001

;low melody notes
G4      equ %10101100   ;red, +48
D5      equ %10101000
G5      equ %00010011

;high melody notes
A4      equ %10101011
E5      equ %10100111
A5      equ %10100101

    ;partial sound patterns
KICK0   equ %10011110
KICK1   equ %01111110
SNARE0  equ %10000100
SNARE1  equ %01100100
SNARE2  equ %01100101
SNARE3  equ %01100101

; 000 = square = 4  = E3-As4 of melody
; 001 = bass   = 6  = B1 of bass
; 010 = lead   = 12 = E3- of bass (attenuated version of 101)
; 011 is part of drums
; 100 is part of drums
; 101 = lead   = 12 = B4-E6 of melody
; 110 = saw    = 1  = Cs2-Ds3 of bass
soundTurnArray
    byte 7, 5, 5, 9
    byte 4, 7, 9, 0

; 000 0 Square  = 4
; 001 1 Bass    = 6
; 010 2 Lead    = 12 (attenuated)
; 011 3 Noise   = 8
;
; 100 4 Buzz    = 15
; 101 5 Lead    = 12
; 110 6 Saw     = 1
; 111 7 Engine  = 3
;
soundTypeArray
    byte 4,6,12,8
    byte 15,12,1,3


hatPattern
	byte %00001000
	byte %00001000
	byte %00001000
	byte %00001000


HATSTART equ INTROLEN/2

HATVOLUME equ 7
HATPITCH equ 0
HATSOUND equ 8

song1
#if INTRO
    byte 10,10
    byte 10,10
    byte 10,10
    byte 10,10
#endif
INTROLEN    equ *-song1

    byte 1,2
    byte 1,2
    byte 1,2
    byte 1,2

    byte 1,2
    byte 1,2

    byte 11,12
    byte 11,12
    byte 11,12
    byte 11,12

    byte 11,12
    byte 11,12

    byte 1,2
    byte 1,2
    byte 1,2
    byte 1,2

    byte 0,0
    byte 0,0

SONGLEN equ *-song1

	; End of song marker
	byte 255


song2
#if INTRO
    byte 0,0
    byte 0,0
    byte 0,0
    byte 0,0
#endif

    byte 3,4
    byte 3,5
    byte 3,6
    byte 3,7

    byte 0,0
    byte 0,0

    byte 13,14
    byte 13,15
    byte 16,17
    byte 18,19

    byte 0,0
    byte 0,0

    byte 9,0
    byte 8,0
    byte 7,0
    byte 6,0

    byte 3,4
    byte 3,9

	; End of song marker
	byte 255

	; Higher volume patterns
patternArrayH 						; starts at 0

	; Muted pattern
	word mute,mute,mute,mute			;0

    word LowBass4_1,LowBass4_2,LowBass4_3,LowBass4_4    ;1
    word LowBass4_5,LowBass4_6,LowBass4_7,LowBass4_8    ;2

    word LowMel1_1,LowMel1_2,LowMel1_3_1,LowMel1_4      ;3
    word LowMel1_1,LowMel1_2,LowMel1_3_2,LowMel1_4      ;4
    word LowMel1_1,LowMel1_2,LowMel1_3_3,LowMel1_4      ;5
    word LowMel1_1,LowMel1_2,LowMel1_3_4,LowMel1_4      ;6
    word LowMel1_1,LowMel1_2,LowMel1_3_5,LowMel1_4      ;7
    word LowMel1_1,LowMel1_2,LowMel1_3_6,LowMel1_4      ;8
    word LowMel1_1,LowMel1_2,LowMel1_3_7,LowMel1_4      ;9

    word DrumsOnly1,DrumsOnly2,DrumsOnly3,DrumsOnly4    ;10

    word HighBass4_1,HighBass4_2,HighBass4_3,HighBass4_4    ;11
    word HighBass4_5,HighBass4_6,HighBass4_7,HighBass4_8    ;12

    word HighMel1_1,HighMel1_2,HighMel1_3_1,HighMel1_4  ;13
    word HighMel1_1,HighMel1_2,HighMel1_3_2,HighMel1_4  ;14
    word HighMel1_1,HighMel1_2,HighMel1_3_3,HighMel1_4  ;15
    word HighMel1_1,HighMel1_2,HighMel1_3_4,HighMel1_4  ;16
    word HighMel1_1,HighMel1_2,HighMel1_3_5,HighMel1_4  ;17
    word HighMel1_1,HighMel1_2,HighMel1_3_6,HighMel1_4  ;18
    word HighMel1_1,HighMel1_2,HighMel1_3_7,HighMel1_4  ;19

	; Lower volume patterns
patternArrayL 						; start at 128

DrumsOnly1
DrumsOnly3
    byte KICK0, KICK1
    byte 255,   255
    byte 255,   255
    byte 255,   255
    byte %10000000

DrumsOnly2
DrumsOnly4
    byte SNARE0,SNARE1
    byte SNARE2,SNARE3
    byte 255,   255
    byte 255,   255
    byte %11000000

LowBass4_1
    byte KICK0, As3
    byte As3,   255
    byte As3,   As3
    byte As3,   As3
    byte %11001000

LowBass4_2
    byte SNARE0,SNARE1
    byte 255,   255
    byte As3,   As3
    byte As3,   As3
    byte %10001000

LowBass4_3
    byte KICK0, C4
    byte C4,    255
    byte C4,    C4
    byte C4,    C4
    byte %11001000

LowBass4_4
    byte SNARE0,SNARE1
    byte 255,   255
    byte C4,    C4
    byte C4,    C4
    byte %10001000

LowBass4_5
    byte KICK0, F3
    byte F3,    255
    byte F3,    F3
    byte F3,    F3
    byte %11001000

LowBass4_6
    byte SNARE0,SNARE1
    byte 255,   255
    byte F3,    F3
    byte F3,    F3
    byte %10001000

LowBass4_7
    byte G3,    255
    byte G3,    255
    byte G3,    255
    byte G3,    255
    byte %10000000

LowBass4_8
    byte SNARE0,G3
    byte G3,    255
    byte G3,    G3
    byte G3,    G3
    byte %11001000

HighBass4_1
    byte KICK0, C4
    byte C4,    255
    byte C4,    C4
    byte C4,    C4
    byte %11001000

HighBass4_2
    byte SNARE0,SNARE1
    byte 255,   255
    byte C4,    C4
    byte C4,    C4
    byte %10001000

HighBass4_3
    byte KICK0, D4
    byte D4,    255
    byte D4,    D4
    byte D4,    D4
    byte %11001000

HighBass4_4
    byte SNARE0,SNARE1
    byte 255,   255
    byte D4,    D4
    byte D4,    D4
    byte %10001000

HighBass4_5
    byte KICK0, G3
    byte G3,    255
    byte G3,    G3
    byte G3,    G3
    byte %11001000

HighBass4_6
    byte SNARE0,SNARE1
    byte 255,   255
    byte G3,    G3
    byte G3,    G3
    byte %10001000

HighBass4_7
    byte A3,    255
    byte A3,    255
    byte A3,    255
    byte A3,    255
    byte %10000000

HighBass4_8
    byte SNARE0,A3
    byte A3,    255
    byte A3,    A3
    byte A3,    A3
    byte %11001000

LowMel1_1
    byte G4,   G4
    byte G4,   G4
    byte D5,   D5
    byte D5,   D5
    byte %10001000

LowMel1_2
    byte G4,   G4
    byte 255,   255
    byte G4,   G4
    byte G4,   G4
    byte %10001000

LowMel1_3_1
    byte G5,   G5
    byte G5,   G5
    byte D5,   D5
    byte D5,   D5
    byte %10001000

LowMel1_3_2
    byte D5,   D5
    byte D5,   D5
    byte G4,   G4
    byte G4,   G4
    byte %10001000

LowMel1_3_3
    byte G5,   G5
    byte G4,   G4
    byte D5,   D5
    byte D5,   D5
    byte %10101000

LowMel1_3_4
    byte D5,   D5
    byte G5,   G5
    byte G4,   G4
    byte D5,   D5
    byte %10101010

LowMel1_3_5
    byte D5,   D5
    byte D5,   D5
    byte G5,   G5
    byte G4,   G4
    byte %10001000

LowMel1_3_6
    byte G5,   G5
    byte G5,   G5
    byte D5,   D5
    byte G5,   255
    byte %10001000

LowMel1_3_7
    byte G5,   G5
    byte G4,   G4
    byte D5,   D5
    byte G4,   G4
    byte %10001000

LowMel1_4
    byte G5,   G5
    byte 255,  255
    byte G5,   G5
    byte G5,   G5
    byte %10001000

HighMel1_1
    byte A4,   A4
    byte A4,   A4
    byte E5,   E5
    byte E5,   E5
    byte %10001000

HighMel1_2
    byte A4,   A4
    byte 255,   255
    byte A4,   A4
    byte A4,   A4
    byte %10001000

HighMel1_3_1
    byte A5,   A5
    byte A5,   A5
    byte E5,   E5
    byte E5,   E5
    byte %10001000

HighMel1_3_2
    byte A5,   A5
    byte A5,   A5
    byte E5,   255
    byte E5,   E5
    byte %10001010

HighMel1_3_3
    byte A5,   A5
    byte A5,   A5
    byte E5,   E5
    byte A4,   A4
    byte %10001010

HighMel1_3_4
    byte A5,   A5
    byte A5,   A5
    byte A4,   A4
    byte E5,   E5
    byte %10001010

HighMel1_3_5
    byte E5,   E5
    byte A5,   A5
    byte A4,   A4
    byte A4,   A4
    byte %10101000

HighMel1_3_6
    byte E5,   E5
    byte E5,   E5
    byte A4,   A4
    byte A4,   A4
    byte %10001000

HighMel1_3_7
    byte A5,   A5
    byte A4,   A4
    byte E5,   E5
    byte A4,   A4
    byte %10101010

HighMel1_4
    byte A5,   A5
    byte 255,   255
    byte A5,   A5
    byte A5,   A5
    byte %10001000

mute
	byte 255,255,255,255
	byte 255,255,255,255

	byte 255